/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.common.Counter;
import ibm.nways.jdm.common.Gauge;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.topology.EndPointLink;
import ibm.nways.jdm.traceroute.Util;
import ibm.nways.mib2.model.InterfaceModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class NetInterface
implements Serializable,
EndPointLink {
    protected String voyagerAddress;
    private static ResourceBundle strings = ResourceBundle.getBundle((class$ibm$nways$jdm$traceroute$TraceRouteResources != null ? class$ibm$nways$jdm$traceroute$TraceRouteResources : (class$ibm$nways$jdm$traceroute$TraceRouteResources = NetInterface.class$("ibm.nways.jdm.traceroute.TraceRouteResources"))).getName());
    public static final String UNAVAILABLE = strings.getString("Unavailable");
    protected IPAddress ipAddress;
    protected Integer ifIndex;
    protected OctetString ifDescr;
    protected Integer ifType;
    protected Gauge ifSpeed;
    protected Integer ifOperStatus;
    protected UtilizationTracker utilizationThread;
    protected Counter ifInOctets1;
    protected Counter ifOutOctets1;
    protected Date inOutReading1;
    protected Counter ifInOctets2;
    protected Counter ifOutOctets2;
    protected Date inOutReading2;
    private boolean snmpLookupDone;
    protected String communityName = "public";
    public static final String PROP_CHANGE_UTILIZATION = "utilization";
    protected Vector listeners;
    private static final boolean debug = false;
    static /* synthetic */ Class class$ibm$nways$jdm$traceroute$TraceRouteResources;

    public NetInterface(IPAddress iPAddress, Integer n) {
        this(iPAddress, n, "public", null);
    }

    public NetInterface(IPAddress iPAddress, Integer n, String string) {
        this(iPAddress, n, string, null);
    }

    public NetInterface(IPAddress iPAddress, Integer n, String string, String string2) {
        this.ipAddress = new IPAddress(iPAddress.toString());
        this.ifIndex = new Integer(n);
        this.communityName = string;
        this.voyagerAddress = string2;
        this.snmpLookupDone = false;
    }

    public IPAddress getIPAddress() {
        return new IPAddress(this.ipAddress.toString());
    }

    public String getId() {
        String string = String.valueOf(this.ipAddress) + ":" + String.valueOf(this.ifIndex);
        return string;
    }

    public String getLabelString() {
        return null;
    }

    public void setLabelString(String string) {
    }

    public OctetString getIfDescr() {
        this.getDataFromSnmp();
        return new OctetString(this.ifDescr);
    }

    public String getIfDescrString() {
        this.getDataFromSnmp();
        if (this.ifDescr == null) {
            return UNAVAILABLE;
        }
        return this.ifDescr.toDisplayString();
    }

    public Integer getIfType() {
        this.getDataFromSnmp();
        return new Integer(this.ifType);
    }

    public String getIfTypeString() {
        this.getDataFromSnmp();
        if (this.ifType == null) {
            return UNAVAILABLE;
        }
        String string = "ibm.nways.mib2.model.InterfaceModel.Panel.IfType.";
        int n = this.ifType;
        String string2 = InterfaceModel.Panel.IfTypeEnum.numericToSymbolic(n);
        if (string2.startsWith(string)) {
            string2 = string2.substring(string.length());
        }
        return string2;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public Gauge getIfSpeed() {
        this.getDataFromSnmp();
        return new Gauge(this.ifSpeed.getValue());
    }

    public String getIfSpeedString() {
        this.getDataFromSnmp();
        if (this.ifSpeed == null) {
            return UNAVAILABLE;
        }
        String string = this.ifSpeed.toString();
        if (string.endsWith("000000")) {
            string = String.valueOf(string.substring(0, string.length() - 6)) + strings.getString("Mbps");
        } else if (string.endsWith("000")) {
            string = String.valueOf(string.substring(0, string.length() - 3)) + strings.getString("Kbps");
        }
        return string;
    }

    public Integer getIfOperStatus() {
        this.getDataFromSnmp();
        return new Integer(this.ifOperStatus);
    }

    public String getIfOperStatusString() {
        this.getDataFromSnmp();
        if (this.ifOperStatus == null) {
            return UNAVAILABLE;
        }
        if (this.ifOperStatus.equals(new Integer(1))) {
            return strings.getString("LinkUp");
        }
        if (this.ifOperStatus.equals(new Integer(2))) {
            return strings.getString("LinkDown");
        }
        return strings.getString("LinkTesting");
    }

    public String getUtilization(boolean bl) {
        this.getDataFromSnmp();
        if (this.isLanAdapter() == null || this.isLanAdapter().booleanValue()) {
            return UNAVAILABLE;
        }
        if (this.ifInOctets1 == null) {
            return UNAVAILABLE;
        }
        if (this.ifInOctets2 == null) {
            if (this.utilizationThread == null) {
                this.utilizationThread = new UtilizationTracker();
                this.utilizationThread.start();
            }
            if (bl) {
                while (!this.utilizationThread.isFinished()) {
                    try {
                        this.utilizationThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                return "...";
            }
        }
        return this.calcUtilization();
    }

    protected String calcUtilization() {
        if (this.isLanAdapter() == null || this.isLanAdapter().booleanValue()) {
            return null;
        }
        float f = (this.inOutReading2.getTime() - this.inOutReading1.getTime()) / 1000L;
        float f2 = this.ifSpeed.getValue();
        long l = this.ifInOctets1.getValue();
        long l2 = this.ifInOctets2.getValue();
        long l3 = this.ifOutOctets1.getValue();
        long l4 = this.ifOutOctets2.getValue();
        float f3 = l2 > l ? (float)(l2 - l) : (float)(Long.MAX_VALUE - (l - l2));
        float f4 = l4 > l3 ? (float)(l4 - l3) : (float)(Long.MAX_VALUE - (l3 - l4));
        f3 = f3 * 8.0f * 100.0f;
        f4 = f4 * 8.0f * 100.0f;
        float f5 = f3 / f / f2;
        float f6 = f4 / f / f2;
        return String.valueOf(Math.round(f5)) + "% / " + Math.round(f6) + "%";
    }

    public Boolean isLanAdapter() {
        this.getDataFromSnmp();
        if (this.ifType == null) {
            return null;
        }
        switch (this.ifType) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 26: 
            case 62: 
            case 69: 
            case 115: 
            case 117: {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    protected synchronized void getDataFromSnmp() {
        if (this.snmpLookupDone) {
            return;
        }
        String string = this.ifIndex.toString();
        String[] stringArray = new String[]{"1.3.6.1.2.1.2.2.1.2." + string, "1.3.6.1.2.1.2.2.1.3." + string, "1.3.6.1.2.1.2.2.1.5." + string, "1.3.6.1.2.1.2.2.1.8." + string, "1.3.6.1.2.1.2.2.1.10." + string, "1.3.6.1.2.1.2.2.1.16." + string};
        Object[] objectArray = Util.lookupMibVars(this.ipAddress, this.communityName, stringArray, this.voyagerAddress);
        this.ifDescr = (OctetString)objectArray[0];
        this.ifType = (Integer)objectArray[1];
        this.ifSpeed = (Gauge)objectArray[2];
        this.ifOperStatus = (Integer)objectArray[3];
        this.ifInOctets1 = (Counter)objectArray[4];
        this.ifOutOctets1 = (Counter)objectArray[5];
        this.inOutReading1 = new Date();
        this.snmpLookupDone = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(propertyChangeListener);
        }
    }

    protected void notifyPropertyChangeListeners(String string, String string2, String string3) {
        if (this.listeners == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, string2, string3);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((PropertyChangeListener)enumeration.nextElement()).propertyChange(propertyChangeEvent);
        }
    }

    public String toString() {
        return "Port " + this.ifIndex + " on " + this.ipAddress.toString();
    }

    public void debugDump() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("INTERFACE");
            System.out.println("    ipAddress: " + this.ipAddress);
            System.out.println("      ifIndex: " + this.ifIndex);
            if (!this.snmpLookupDone) {
                System.out.println("   snmpLookup: not done.  Looking stuff up now.");
                this.getDataFromSnmp();
            }
            System.out.println("      ifDescr: " + this.getIfDescrString());
            System.out.println("      ifSpeed: " + this.getIfSpeedString());
            System.out.println(" ifOperStatus: " + this.getIfOperStatusString());
            System.out.println("       ifType: " + this.getIfTypeString());
            if (this.ifInOctets1 == null) {
                System.out.println("  ifInOctets1: null");
                System.out.println(" ifOutOctets1: null");
                System.out.println("inOutReading1: null");
            } else {
                System.out.println("  ifInOctets1: " + this.ifInOctets1.getValue());
                System.out.println(" ifOutOctets1: " + this.ifOutOctets1.getValue());
                System.out.println("inOutReading1: " + this.inOutReading1.toString());
            }
            if (this.ifInOctets2 == null) {
                System.out.println("  ifInOctets2: null");
                System.out.println(" ifOutOctets2: null");
                System.out.println("inOutReading2: null");
            } else {
                System.out.println("  ifInOctets2: " + this.ifInOctets2.getValue());
                System.out.println(" ifOutOctets2: " + this.ifOutOctets2.getValue());
                System.out.println("inOutReading2: " + this.inOutReading2.toString());
            }
            System.out.println(" communityNam: " + this.communityName);
            System.out.println("  voyagerAddr: " + this.voyagerAddress);
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class UtilizationTracker
    extends Thread {
        private final long MINUTE = 60000L;
        private boolean finished = false;

        public void run() {
            long l = new Date().getTime() - NetInterface.this.inOutReading1.getTime();
            while (l < 60000L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(Math.min(l, 10000L));
                }
                catch (InterruptedException interruptedException) {}
                l = new Date().getTime() - NetInterface.this.inOutReading1.getTime();
            }
            String string = NetInterface.this.ifIndex.toString();
            String[] stringArray = new String[]{"1.3.6.1.2.1.2.2.1.10." + string, "1.3.6.1.2.1.2.2.1.16." + string};
            Object[] objectArray = Util.lookupMibVars(NetInterface.this.ipAddress, NetInterface.this.communityName, stringArray, NetInterface.this.voyagerAddress);
            NetInterface.this.ifInOctets2 = (Counter)objectArray[0];
            NetInterface.this.ifOutOctets2 = (Counter)objectArray[1];
            NetInterface.this.inOutReading2 = new Date();
            NetInterface.this.notifyPropertyChangeListeners(NetInterface.PROP_CHANGE_UTILIZATION, "", NetInterface.this.calcUtilization());
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished;
        }

        UtilizationTracker() {
            NetInterface.this = NetInterface.this;
        }
    }
}

